@extends('layouts.app')

@section('title', 'Admin Dashboard')

@section('content')
<div class="admin-dashboard">
    <div class="container">
        <h1>Admin Dashboard</h1>
        
        <div class="stats-grid">
            <div class="stat-card">
                <h3>Total Tickets</h3>
                <p class="stat-number">{{ $stats['total_tickets'] }}</p>
            </div>
            <div class="stat-card">
                <h3>Open Tickets</h3>
                <p class="stat-number">{{ $stats['open_tickets'] }}</p>
            </div>
            <div class="stat-card">
                <h3>In Progress</h3>
                <p class="stat-number">{{ $stats['in_progress_tickets'] }}</p>
            </div>
            <div class="stat-card">
                <h3>Closed</h3>
                <p class="stat-number">{{ $stats['closed_tickets'] }}</p>
            </div>
        </div>

        <div class="admin-actions">
            <a href="{{ route('admin.tickets') }}" class="btn btn-primary">View All Tickets</a>
            <a href="{{ route('admin.settings') }}" class="btn btn-secondary">Settings</a>
            <a href="{{ route('admin.knowledgebase') }}" class="btn btn-secondary">Knowledge Base</a>
        </div>

        <div class="recent-tickets">
            <h2>Recent Tickets</h2>
            <div class="tickets-list">
                @foreach($recentTickets as $ticket)
                    <div class="ticket-card">
                        <div class="ticket-header">
                            <h3><a href="{{ route('admin.tickets.show', $ticket) }}">{{ $ticket->subject }}</a></h3>
                            <span class="badge badge-{{ $ticket->status }}">{{ ucfirst($ticket->status) }}</span>
                        </div>
                        <p class="ticket-meta">
                            <span>By: {{ $ticket->user->name }}</span>
                            <span>Created: {{ $ticket->created_at->format('M d, Y H:i') }}</span>
                        </p>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection

